/* ********************************************************************************
# If you should have any comments, suggestions or improvements to these samples, 
# we welcome you to contact us at SampleCode@melissadata.com also please visit our 
# developers bulletin board at forum.melissadata.com.
# ******************************************************************************** */

/* ********************* LICENSE STRINGS **********************
#*     To unlock the full functionality of Address Object,     *
#* please call a sales representative at 1-800-MELISSA ext. 3  *
#*         (1-800-635-4772 x3) for a license string.           *
#*  Address Object will not function without a valid           *
#*      			  license string 			          	   *
#************************************************************* */

set pagesize 1000;
set long 20000;
set echo off;
set pages 999;
set serveroutput off;

truncate table log;
commit;

declare
  ao pls_integer;
  zo pls_integer;
  bno varchar2(100);
  val varchar2(32767);
  formcontents long;
  ok integer;
  a float;
  b float;
  c float;
  d float;
begin

  insert into log values('starting');
  commit;

  ao := mdAddrCreate();
  insert into log values('created mdAddr object');
  commit;

  ok := mdAddrSetLicenseString(ao, 'SET_LICENSE_HERE');
  insert into log values('set license: ok=' || ok);
  commit;

  bno := mdAddrGetBuildNumber(ao);
  insert into log values('build number= ' || bno);
  commit;

  mdAddrSetPathToUSFiles(ao, 'SET_PATH_HERE');
  insert into log values('set path to US files');
  commit;

  mdAddrSetCASSEnable(ao, 1);
  insert into log values('set CASS Enable = T');
  commit;

  mdAddrSetPathToDPVDataFiles(ao, 'SET_PATH_HERE');
  insert into log values('set path to DPV files');
  commit;

  ok := mdAddrInitializeDataFiles(ao);
  insert into log values('init datafiles: error=' || ok);
  commit;

  val := mdAddrGetInitializeErrorString(ao);
  insert into log values('init error string = ' || val);
  commit;

  val := mdAddrGetDatabaseDate(ao);
  insert into log values('database date = ' || val);
  commit;

  val := mdAddrGetExpirationDate(ao);
  insert into log values('exp date = ' || val);
  commit;

  mdAddrClearProperties(ao);
  insert into log values('clear properties');
  commit;

  mdAddrSetAddress(ao, '308 S Basil St');
  mdAddrSetLastLine(ao, 'Anaheim, CA, 92808 ');
  insert into log values('set address');
  commit;

  ok := mdAddrVerifyAddress(ao);
  insert into log values('verify: ok=' || ok);
  commit;

  val := mdAddrGetStatusCode(ao);
  insert into log values('status=' || val);
  commit;

  val := mdAddrGetAddress(ao);
  insert into log values('addr=  ' || val);
  commit;

  val := mdAddrGetAddress2(ao);
  insert into log values('addr2= ' || val);
  commit;

  val := mdAddrGetCity(ao);
  insert into log values('city=  ' || val);
  commit;

  val := mdAddrGetState(ao);
  insert into log values('state= ' || val);
  commit;

  val := mdAddrGetZip(ao);
  insert into log values('zip=   ' || val);
  commit;

  val := mdAddrGetPlus4(ao);
  insert into log values('plus4= ' || val);
  commit;

  ok := mdAddrSaveFormPS3553(ao, '/tmp/formps3553.txt');
  insert into log values('save ps3553: ok=' || ok);
  commit;

  mdAddrDestroy(ao);
  insert into log values('destroyed mdAddr object');
  commit;

end;
.
run

select * from log;
